// This class extends the Arrow class for the FSA Grammar
// to also be used in a Token Canvas

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.interpreter.*;
import au.edu.monash.csse.tonyj.cider.canvas.DrawableToken;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;

public class DrawableArrow extends Arrow implements DrawableToken {

	// Private variables
	private Polygon			arrowhead;

	// Constructor
	public DrawableArrow(double start_x, double start_y, double mid_x, double mid_y, double end_x, double end_y,
		double start_radius, double end_radius, boolean active, Color colour)
	{
		super(start_x, start_y, mid_x, mid_y, end_x, end_y, start_radius, end_radius, active, colour);
	}

	// Draw method
	public void draw(Graphics2D g2d)
	{
		CubicCurve2D curve;
		double vx = 0.0;
		double vy = 0.0;
		double theta, midX, midY;

		// Calculate offset end points
		theta = Math.atan2(get_mid_y() - get_start_y(), get_mid_x() - get_start_x());
		double startX = get_start_x() + get_start_radius() * Math.cos(theta);
		double startY = get_start_y() + get_start_radius() * Math.sin(theta);
		theta = Math.atan2(get_mid_y() - get_end_y(), get_mid_x() - get_end_x());
		double endX = get_end_x() + get_end_radius() * Math.cos(theta);
		double endY = get_end_y() + get_end_radius() * Math.sin(theta);

		if (get_active())
			g2d.setColor(Color.blue);
		else
			g2d.setColor(Color.black);
		if (get_colour() != null)
			g2d.setColor(get_colour());

		double dist_se = Math.sqrt(((startX - endX) * (startX - endX)) +
			((startY - endY) * (startY - endY)));
		double dist_sm = Math.sqrt(((startX - get_mid_x()) * (startX - get_mid_x())) +
			((startY - get_mid_y()) * (startY - get_mid_y())));
		double dist_me = Math.sqrt(((get_mid_x() - endX) * (get_mid_x() - endX)) +
			((get_mid_y() - endY) * (get_mid_y() - endY)));

		if (startX == endX && startY == endY) {
			double halfX = (startX - get_mid_x()) / 2.0;
			double halfY = (startY - get_mid_y()) / 2.0;
			curve = new CubicCurve2D.Double(startX, startY,
				get_mid_x() + halfY, get_mid_y() - halfX,
				get_mid_x() - halfY, get_mid_y() + halfX, endX, endY);
			midX = get_mid_x() - halfY;
			midY = get_mid_y() + halfX;
		}
		else {
			vx = (endX - startX) / dist_se;
			vy = (endY - startY) / dist_se;
			curve = new CubicCurve2D.Double(startX, startY,
				get_mid_x() - (0.5 * dist_sm * vx), get_mid_y() - (0.5 * dist_sm * vy),
				get_mid_x() + (0.5 * dist_me * vx), get_mid_y() + (0.5 * dist_me * vy), endX, endY);
			midX = get_mid_x() + (0.5 * dist_me * vx);
			midY = get_mid_y() + (0.5 * dist_me * vy);
		}
		g2d.draw(curve);
		int xc[] = new int[3];
		int yc[] = new int[3];
		double angle = Math.atan2(midY - endY, midX - endX);
		xc[0] = (int) endX;
		yc[0] = (int) endY;
		xc[1] = (int) (endX + (9.0 * Math.cos(angle + (Math.PI / 6.0))));
		yc[1] = (int) (endY + (9.0 * Math.sin(angle + (Math.PI / 6.0))));
		xc[2] = (int) (endX + (9.0 * Math.cos(angle - (Math.PI / 6.0))));
		yc[2] = (int) (endY + (9.0 * Math.sin(angle - (Math.PI / 6.0))));
		arrowhead = new Polygon(xc, yc, 3);
		g2d.fill(arrowhead);
		if (get_active()) {
			g2d.setColor(Color.red);
			g2d.fill(new Rectangle2D.Double(get_mid_x() - 1.0, get_mid_y() - 1.0, 3.0, 3.0));
			g2d.fill(new Rectangle2D.Double(get_end_x() - 1.0, get_end_y() - 1.0, 3.0, 3.0));
			g2d.fill(new Rectangle2D.Double(get_start_x() - 1.0, get_start_y() - 1.0, 3.0, 3.0));
		}
	}

	// Contains method
	public boolean contains(double x, double y)
	{
		if (arrowhead != null && arrowhead.contains(x, y))
			return true;
		return false;
	}
}

