// This class extends the Circle class for the FSA Grammar
// to also be used in a Token Canvas

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.interpreter.*;
import au.edu.monash.csse.tonyj.cider.canvas.DrawableToken;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class DrawableCircle extends Circle implements DrawableToken {

	// Constructor
	public DrawableCircle(double radius, double mid_x, double mid_y, boolean active, Color colour)
	{
		super(radius, mid_x, mid_y, active, colour);
	}

	// Draw method
	public void draw(Graphics2D g2d)
	{
		if (get_active())
			g2d.setColor(Color.blue);
		else
			g2d.setColor(Color.black);
		if (get_colour() != null)
			g2d.setColor(get_colour());

		g2d.drawOval((int) (get_mid_x() - get_radius()), (int) (get_mid_y() - get_radius()), (int) (get_radius() * 2.0),
			(int) (get_radius() * 2.0));
		if (get_active()) {
			g2d.setColor(Color.red);
			g2d.fill(new Rectangle2D.Double(get_mid_x() + get_radius() - 1.0, get_mid_y() - 1.0, 3.0, 3.0));
			g2d.fill(new Rectangle2D.Double(get_mid_x() - 1.0, get_mid_y() - 1.0, 3.0, 3.0));
		}
	}

	// Contains method
	public boolean contains(double x, double y)
	{
		double distance = ((x - get_mid_x()) * (x - get_mid_x())) + ((y - get_mid_y()) * (y - get_mid_y()));
		return (distance <= (get_radius() * get_radius()));
	}
}

