// This class extends the Line class for the FSA Grammar
// to also be used in a Token Canvas

package fsa_editor;

import au.edu.monash.csse.tonyj.cider.interpreter.*;
import au.edu.monash.csse.tonyj.cider.canvas.DrawableToken;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class DrawableLine extends Line implements DrawableToken {

	// Constructor
	public DrawableLine(double start_x, double start_y, double end_x, double end_y,
		double start_radius, double end_radius, boolean active, Color colour)
	{
		super(start_x, start_y, end_x, end_y, start_radius, end_radius, active, colour);
	}

	// Draw method
	public void draw(Graphics2D g2d)
	{
		// Calculate offset end points
		double theta;
		theta = Math.atan2(get_end_y() - get_start_y(), get_end_x() - get_start_x());
		double startX = get_start_x() + get_start_radius() * Math.cos(theta);
		double startY = get_start_y() + get_start_radius() * Math.sin(theta);
		theta = Math.atan2(get_start_y() - get_end_y(), get_start_x() - get_end_x());
		double endX = get_end_x() + get_end_radius() * Math.cos(theta);
		double endY = get_end_y() + get_end_radius() * Math.sin(theta);

		if (get_active())
			g2d.setColor(Color.blue);
		else
			g2d.setColor(Color.black);
		if (get_colour() != null)
			g2d.setColor(get_colour());

		g2d.drawLine((int) startX, (int) startY, (int) endX, (int) endY);
		if (get_active()) {
			g2d.setColor(Color.red);
			g2d.fill(new Rectangle2D.Double(get_end_x() - 1.0, get_end_y() - 1.0, 3.0, 3.0));
			g2d.fill(new Rectangle2D.Double(get_start_x() - 1.0, get_start_y() - 1.0, 3.0, 3.0));
		}
	}

	// Contains method
	public boolean contains(double x, double y)
	{
		return false;
	}
}

